/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity.render.feature;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.adventurez.entity.DragonEntity;
import net.adventurez.entity.model.DragonModel;
import net.adventurez.entity.render.feature.layer.ExtraRenderLayer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;

@Environment(value=EnvType.CLIENT)
public class DragonEyesFeatureRenderer
extends RenderLayer<DragonEntity, DragonModel<DragonEntity>> {
    private static final RenderType EYE_LAYER = ExtraRenderLayer.getGlowing(new ResourceLocation("adventurez:textures/entity/feature/dragon_eyes_feature.png"));
    private static final RenderType FRIENDLY_EYE_LAYER = ExtraRenderLayer.getGlowing(new ResourceLocation("adventurez:textures/entity/feature/friendly_dragon_eyes_feature.png"));
    private static final RenderType FRIENDLY_ORANGE_EYE_LAYER = ExtraRenderLayer.getGlowing(new ResourceLocation("adventurez:textures/entity/feature/friendly_orange_dragon_eyes_feature.png"));

    public DragonEyesFeatureRenderer(RenderLayerParent<DragonEntity, DragonModel<DragonEntity>> featureRendererContext) {
        super(featureRendererContext);
    }

    public void render(PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, DragonEntity dragonEntity, float f, float g, float h, float j, float k, float l) {
        VertexConsumer vertexConsumer = vertexConsumerProvider.m_6299_(EYE_LAYER);
        if (dragonEntity.isTamed()) {
            vertexConsumer = (Boolean)dragonEntity.m_20088_().m_135370_(DragonEntity.OTHER_EYES) != false ? vertexConsumerProvider.m_6299_(FRIENDLY_ORANGE_EYE_LAYER) : vertexConsumerProvider.m_6299_(FRIENDLY_EYE_LAYER);
        }
        ((DragonModel)this.m_117386_()).m_7695_(matrixStack, vertexConsumer, 0xF00000, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }
}

